setwd("<your directory or folder path>")
df1 <- read.csv("20180701 Example 11.2 BMA v.2.csv")
#
#
#  need to execute library(BMA) once during R  session
library(BMA)
#
# VARIABLES:
# X.01
# X.02
# X.03
# X.04
# X.05
# X.06
# X.07
# X.08
# X.09
# X.10
# Response
#
nbin <- nrow(df1)
testind <- rbinom(n=nbin,size=1,prob=0.1) 

df2 <- data.frame(cbind(df1,testind))

attach(df2)
dftest <- subset(df2,testind==1)
dftrain <- subset(df2,testind==0)


#
detach(df2)
attach(dftrain)
prior.p <- c(0.9,0.001,0.9,0.001,0.001,0.9,0.9,0.9,0.9,0.001)
#prior.p <- c(0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1)
bma.model <- bic.glm(f=Response ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,data=dftrain,glm.family=gaussian(),prior.param=prior.p)
linreg <- lm(Response ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,data=dftrain)
postcoeff <- bma.model$postmean
Response.pred <- postcoeff[1] + postcoeff[2]*X.01 + postcoeff[3]*X.02 + postcoeff[4]*X.03 + postcoeff[5]*X.04 + postcoeff[6]*X.05 + postcoeff[7]*X.06 + postcoeff[8]*X.07 + postcoeff[9]*X.08 + postcoeff[10]*X.09 + postcoeff[11]*X.10;
# Make some plots:
plot(x=Response,y=Response.pred,pch=1,xlab="Observed",ylab="Predicted",main="Predicted Response vs. Observed")
points(x=Response,y=linreg$fitted.values,pch=2)
points(x=Response,y=Response,pch=3)
legend(x=0.0,y=150,legend=c("BMA","OLS","Observed Response"),pch=c(1,2,3))
#
# dev.new() allows more plots to be made without overwriting previous plots
#
summary(linreg)
lm.coeffs <- linreg$coefficients

detach(dftrain)
attach(dftest)
BMA.OOS <- postcoeff[1] + postcoeff[2]*X.01 + postcoeff[3]*X.02 + postcoeff[4]*X.03 + postcoeff[5]*X.04 + postcoeff[6]*X.05 + postcoeff[7]*X.06 + postcoeff[8]*X.07 + postcoeff[9]*X.08 + postcoeff[10]*X.09 + postcoeff[11]*X.10;
lm.OOS <- lm.coeffs[1] + lm.coeffs[2]*X.01 + lm.coeffs[3]*X.02 + lm.coeffs[4]*X.03 + lm.coeffs[5]*X.04 + lm.coeffs[6]*X.05 + lm.coeffs[7]*X.06 + lm.coeffs[8]*X.07 + lm.coeffs[9]*X.08 + lm.coeffs[10]*X.09 + lm.coeffs[11]*X.10;
dev.new()
plot(x=Response,y=BMA.OOS,pch=1,xlab="Observed",ylab="Predicted",main="OOS Predicted Response vs. Observed")
points(x=Response,y=lm.OOS,pch=2)
points(x=Response,y=Response,pch=3)
legend(x=0.0,y=100,legend=c("BMA OOS","OLS OOS","Observed Response"),pch=c(1,2,3))
